﻿-- --------------------------------------------------
-- default read rights for everybody in the root channel
-- --------------------------------------------------
IF NOT EXISTS (select [PrincipalID] from [dbo].[NB_Principal] where [LoginName] = 'Everybody')
	INSERT INTO [dbo].[NB_Principal] ([Type], [DisplayName], [GroupId], [LoginName]) VALUES (1, N'Everybody', NULL, N'Everybody')

declare @rootID int;
set @rootID = (select [ChannelID] from [dbo].[NB_Channel] where [Name] = 'Root' and [ParentChannelID] IS NULL)

declare @everybodyID int;
set @everybodyID = (select [PrincipalID] from [dbo].[NB_Principal] where [LoginName] = 'Everybody')

IF NOT EXISTS (select [ChannelRightsID] from [dbo].[NB_ChannelRights] where [ChannelID] = @rootID and [PrincipalID] = @everybodyID)
	INSERT INTO [dbo].[NB_ChannelRights] ([ChannelID], [PrincipalID], [Level]) VALUES (@rootID, @everybodyID, 1)